## Gallery #####################################################################
##
## A basic setup for a gallery screen, using Ren'Py's built-in Gallery
## system. More information here:
## https://www.renpy.org/doc/html/rooms.html#image-gallery
##

init python:

    ## First, some constants to speed up declarations

    ## The size of gallery buttons/thumbnails
    gallery_thumb_size = (400, 225)
    ## For convenience's sake: list off all the gallery image
    ## names we're going to use in this gallery
    gallery_buttons = [
        'story_dog', 'story_beast', 'fluff_lou_cynthia_r1', 'fluff_lou_garland_r1', 'fluff_triple_r1'
    ]

    ## Set up the gallery
    g = Gallery()
    g.locked_button = Image("gui/button/gallery_locked_thumb.webp", oversample = 2)

    ## And declare the various gallery images
    ## This file doesn't assume the presence of any GUI files, so I'm
    ## just using basic squares, declared as images below, but you will
    ## replace these with actual images.
    ## These use the names declared in the gallery_buttons list

    g.button("fluff_lou_cynthia_r1")
    g.condition("persistent.cynthiarom")
    g.image("fluff_lou_cynthia_r1")

    g.button("fluff_lou_garland_r1")
    g.condition("persistent.garlandrom")
    g.image("fluff_lou_garland_r1")

    g.button("fluff_triple_r1")
    g.condition("persistent.triplerom")
    g.image("fluff_triple_r1")
    g.transform(Transform("fluff_triple_r1", xysize=(1170, 1080), xcenter=0.5))

    g.button("story_dog")
    g.unlock_image("story_dog")

    g.button("story_beast")
    g.condition("persistent.fadetoblack")
    g.image("black", "story_beast")
    g.image("black", "story_beast_smile")

## Declarations for the images used in the gallery. May or may not
## be needed if you're using Ren'Py's automatic image names.
image cg xia1 = Transform("#bd580a", xysize=(config.screen_width, config.screen_height))
image cg ashwin1 = Transform("#127151", xysize=(config.screen_width, config.screen_height))
image cg zoran1 = Transform("#8157b9", xysize=(config.screen_width, config.screen_height))

## This is just the button name + _thumb to make it easier to iterate
image story_dog_thumb = Transform("story_dog", xysize=gallery_thumb_size)
image story_beast_thumb = Transform("black", xysize=gallery_thumb_size)
image fluff_lou_cynthia_r1_thumb = Transform("#8157b9", xysize=gallery_thumb_size)
image fluff_lou_garland_r1_thumb = Transform("#8157b9", xysize=gallery_thumb_size)

image fluff_lou_cynthia_r1_thumb_transf = Transform("fluff_lou_cynthia_r1", xysize=gallery_thumb_size, fit="cover")
image fluff_lou_cynthia_r1_thumb = Transform("fluff_lou_cynthia_r1_thumb_transf", crop=(0, 0.2, 400,225))

image fluff_lou_garland_r1_thumb_transf = Transform("fluff_lou_garland_r1", xysize=gallery_thumb_size, fit="cover")
image fluff_lou_garland_r1_thumb = Transform("fluff_lou_garland_r1_thumb_transf", crop=(0, 0.15, 400,225))

image fluff_triple_r1_thumb_transf = Transform("fluff_triple_r1", xysize=gallery_thumb_size, fit="cover")
image fluff_triple_r1_thumb = Transform("fluff_triple_r1_thumb_transf", crop=(0, 0, 400,225))

screen gallery():

    tag menu

    add HBox(Transform("#0a0a0f", xsize=350), "#10131a") # The background; can be whatever

    use game_menu(_("Gallery"))


    fixed:
        style_prefix 'gal'
        ## Organize the gallery images into a grid
        grid 3 2:
            for btn in gallery_buttons:
                add g.make_button(btn, "{}_thumb".format(btn))
            ## If you're not using the loop, this will look instead like:
            # add g.make_button("button_name", "button_thumbnail.png")

style gal_fixed:
    yfill True
    xsize config.screen_width-420
    align (1.0, 0.5)

style gal_grid:
    align (0.5, 0.5)
    xsize config.screen_width-420
    ysize config.screen_height-200
    spacing 50